<?php
	include 'includes/session.php';
	$conn = $pdo->open();

	$output = array('list'=>'','count'=>0);

	if(isset($_SESSION['user'])){
		if(isset($_SESSION['cart'])){
			foreach($_SESSION['cart'] as $row){
				$stmt = $conn->prepare("SELECT *, COUNT(*) AS numrows FROM cart WHERE user_id=:user_id AND product_id=:product_id");
				$stmt->execute(['user_id'=>$user['id'], 'product_id'=>$row['productid']]);
				$crow = $stmt->fetch();
				if($crow['numrows'] < 1){
					$stmt = $conn->prepare("INSERT INTO cart (user_id, product_id, quantity) VALUES (:user_id, :product_id, :quantity)");
					$stmt->execute(['user_id'=>$user['id'], 'product_id'=>$row['productid'], 'quantity'=>$row['quantity']]);
				}
				else{
					$stmt = $conn->prepare("UPDATE cart SET quantity=:quantity WHERE user_id=:user_id AND product_id=:product_id");
					$stmt->execute(['quantity'=>$row['quantity'], 'user_id'=>$user['id'], 'product_id'=>$row['productid']]);
				}
			}
			unset($_SESSION['cart']);
		}

		try{
			$total = 0;
			$stmt = $conn->prepare("SELECT *, products.name AS prodname,cart.id AS cartid FROM cart LEFT JOIN products ON products.id=cart.product_id WHERE user_id=:user");
			$stmt->execute(['user'=>$user['id']]);
			$output['list']= "<div class='table-responsive'>
			<table class='table table-bordered'>
				<thead>
					<tr>
						<td class='text-center'>Image</td>
						<td class='text-left'>Product Name</td>
						<td class='text-left'>Quantity</td>
						<td class='text-right'>Unit Price</td>
						<td class='text-right'>Total</td>
					</tr>
				</thead>
				<tbody>";
			foreach($stmt as $row){
				$image = (!empty($row['photo'])) ? FULL_PATH.'ecommerce/images/'.$row['photo'] : FULL_PATH.'ecommerce/images/noimage.jpg';
				$subtotal = $row['price']*$row['quantity'];
				$total += $subtotal;
				$output['list'] .= "
				<tr>
				<td class='text-center'> 
				<a href='".FULL_PATH."detail/'".$row['id']."'><img src='".$image."' alt='Spicy jalapeno bacon' title='".$row['prodname']."' class='img-thumbnail'></a> 
				</td>
				<td class='text-left'>
					<a href='".FULL_PATH."detail/'".$row['id']."'>".$row['prodname']."</a>                                  <br>
							
				</td>
				
				<td class='text-left'>
					<div class='input-group btn-block' style='max-width: 200px;'>
						<input type='text' id='change_quantity_".$row['cartid']."' name='change_quantity_".$row['cartid']."' value='".$row['quantity']."' size='1' class='form-control'>
						<span class='input-group-btn'>
							<button type='button' data-toggle='tooltip'  title='' class='btn btn-primary update_cart_quantity' data-id='".$row['cartid']."' data-original-title='Update'><i class='fa fa-refresh'></i></button>
							<button type='button' data-toggle='tooltip' title='' class='btn btn-danger cart_page_delete' data-id='".$row['cartid']."'  data-original-title='Remove'><i class='fa fa-times-circle'></i></button>
						</span>
					</div>
				</td>
				<td class='text-right'>AED ".number_format($subtotal,2)."</td>
				<td class='text-right'>AED ".number_format($subtotal,2)."</td>
			</tr>
				";
			}
			$output['list'] .= "
			</tbody>

			</table>
			</div>			
								
						
							<br>
							<div class='row'>
								<div class='col-sm-4 col-sm-offset-8'>
									<table class='table table-bordered'>
										<tbody><tr>
											<td class='text-right'><strong>Sub-Total:</strong></td>
											<td class='text-right'>AED ".number_format($total,2)."</td>
										</tr>
									
										<tr>
											<td class='text-right'><strong>Total:</strong></td>
											<td class='text-right'>AED ".number_format($total,2)."</td>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
						<div class='buttons clearfix'>
							<div class='pull-left'><a href='".FULL_PATH."index' class='btn btn-default'>Continue Shopping</a>
							</div>
							
							<div id='paypal-button' class='pull-right'></div>
	        			
						</div>
			";

		}
		catch(PDOException $e){
			$output .= $e->getMessage();
		}

	}
	else{
		if(count($_SESSION['cart']) != 0){
			
			$total = 0;
			$output['list']= "<div class='table-responsive'>
			<table class='table table-bordered'>
				<thead>
					<tr>
						<td class='text-center'>Image</td>
						<td class='text-left'>Product Name</td>
						<td class='text-left'>Quantity</td>
						<td class='text-right'>Unit Price</td>
						<td class='text-right'>Total</td>
					</tr>
				</thead>
				<tbody>";
				
			foreach($_SESSION['cart'] as $row){
				$stmt = $conn->prepare("SELECT *, products.name AS prodname, category.name AS catname FROM products LEFT JOIN category ON category.id=products.category_id WHERE products.id=:id");
				$stmt->execute(['id'=>$row['productid']]);
				$product = $stmt->fetch();
				$image = (!empty($product['photo'])) ? FULL_PATH.'ecommerce/images/'.$product['photo'] : FULL_PATH.'ecommerce/images/noimage.jpg';
				$subtotal = $product['price']*$row['quantity'];
				$total += $subtotal;
			

				$output['list'].="<tr>
				<td class='text-center'> 
				<a href='".FULL_PATH."detail/".$row['productid']."'><img src='".$image."' alt='Spicy jalapeno bacon' title='".$product['prodname']."' class='img-thumbnail'></a> 
				</td>
				<td class='text-left'>
					<a href='".FULL_PATH."detail/".$row['productid']."'>".$product['prodname']."</a>                                  <br>
							
				</td>
				
				<td class='text-left'>
					<div class='input-group btn-block' style='max-width: 200px;'>
						<input type='text' id='change_quantity_".$row['productid']."' name='change_quantity_".$row['productid']."' value='".$row['quantity']."' size='1' class='form-control'>
						<span class='input-group-btn'>
							<button type='submit' data-toggle='tooltip' title='' class='btn btn-primary update_cart_quantity' data-id='".$row['productid']."' data-original-title='Update'><i class='fa fa-refresh'></i></button>
							<button type='button' data-toggle='tooltip' title='' class='btn btn-danger cart_page_delete' data-id='".$row['productid']."'  data-original-title='Remove'><i class='fa fa-times-circle'></i></button>
						</span>
					</div>
				</td>
				<td class='text-right'>AED ".number_format($subtotal, 2)."</td>
				<td class='text-right'>AED ".number_format($subtotal, 2)."</td>
			</tr>";
				
			}

			$output['list'] .= "
			</tbody>

			</table>
			</div>			
								
						
							<br>
							<div class='row'>
								<div class='col-sm-4 col-sm-offset-8'>
									<table class='table table-bordered'>
										<tbody><tr>
											<td class='text-right'><strong>Sub-Total:</strong></td>
											<td class='text-right'>AED ".number_format($total,2)."</td>
										</tr>
									
										<tr>
											<td class='text-right'><strong>Total:</strong></td>
											<td class='text-right'>AED ".number_format($total,2)."</td>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
						<div class='buttons clearfix'>
							<div class='pull-left'><a href='".FULL_PATH."index' class='btn btn-default'>Continue Shopping</a>
							</div>
							<div class='pull-right'><a href='".FULL_PATH."ecommerce/index.php' class='btn btn-default'>Please Login to Checkout</a>
							</div>
							
	        		
						
						</div>
						
			";
		}

		else{
			$output['list']= "
				<tr>
					<td colspan='6' align='center'>Shopping cart empty</td>
				<tr>
			";
		}
		
	}

	$pdo->close();
	echo json_encode($output);

?>

