<?php
	include 'includes/session.php';

	if(isset($_SESSION['user'])){
		$conn = $pdo->open();

		$stmt = $conn->prepare("SELECT * FROM cart LEFT JOIN products on products.id=cart.product_id WHERE user_id=:user_id");
		$stmt->execute(['user_id'=>$user['id']]);

		$total = 0;
		foreach($stmt as $row){
			$subtotal = $row['price'] * $row['quantity'];
			$total += $subtotal;
		}
		$pdo->close();
// 		echo json_encode($total );
				// Fetching JSON
		$req_url = 'https://open.er-api.com/v6/latest/AED';
		$response_json = file_get_contents($req_url);

		// Continuing if we got a result
		if(false !== $response_json) {

			// Try/catch for json_decode operation
			try {

			// Decoding
			$response_object = json_decode($response_json);

			// YOUR APPLICATION CODE HERE, e.g.
			$base_price = $total; // Your price in AED
			$USD_price = round(($base_price * $response_object->rates->USD));
			echo json_encode($USD_price );
			}
			catch(Exception $e) {
				// Handle JSON parse error...
			}
		}else{

			echo json_encode($total );
		}

		
		

		
	}
?>